#include "MyString.h"


MyString::MyString(unsigned int l) : length(l)
{
    str = new char [l+1];
    str[l] = '\0';
}

MyString::MyString(const char* c)
{
    assert(c);
    length = strlen(c);
    str = new char[length+1];
    strcpy(str,c);
}

MyString::MyString(const MyString& s)
{
    length = s.length;
    str = new char[length+1];
    strcpy(str,s.str);
}

char MyString::getCharAt(unsigned int i) const
{
    assert(i<=length);
    return str[i];
}

void MyString::setCharAt(unsigned int i, char c)
{
    assert(i<=length);
    str[i]=c;
}

void MyString::print() const
{
	cout<<str;
}

char* MyString::toCharArray(char* c) const
{
    assert(c);
    if(strlen(c)==length)
		strcpy(c,str);
    return c;
}

void MyString::append(const MyString& s)
{
	char* tmp=new char[length + s.length +1];
    strcpy(tmp, str);
    strcat(tmp, s.str);
    delete [] str;
    str = tmp;
	length = length + s.length;
}

int MyString::getLength() const
{
    return length;
}

MyString::~MyString()
{

	delete [] str;
}

const MyString& MyString::operator=(const MyString& m)
{
    if(this == &m)
        return *this;
    if(length != m.length)
    {
        delete [] str;
        length = m.length;
        str = new char[length+1];
        assert(str != 0);
    }
    strcpy(str,m.str);
    return *this;
}

bool MyString::operator==(const MyString& m) const
{
    return strcmp(str,m.str) == 0;
}

bool MyString::operator<=(const MyString& m) const
{
    return strcmp(str,m.str) <= 0;
}

bool MyString::operator<(const MyString& m) const
{
    return strcmp(str,m.str) < 0;
}

bool MyString::operator>=(const MyString& m) const
{
    return strcmp(str,m.str) >= 0;
}

bool MyString::operator>(const MyString& m) const
{
    return strcmp(str,m.str) > 0;
}

char MyString::operator()(unsigned int i) const
{
    assert((i+1) < length);
    return str[i+1];
}

char MyString::operator[](unsigned int i) const
{
    assert(i < length);
    return str[i];
}

const MyString& MyString::operator+=(const MyString& m)
{
    append(m);
    return *this;
}

ostream& operator<<(ostream& o, const MyString& m)
{
    o << m.str;
    return o;
}


istream& operator>>(istream& i,  MyString& m)
{
    i >> m.str;
	assert(static_cast<int>(strlen(m.str)) <= m.length);
    return i;
}