#ifndef MYSTRING_H
#define MYSTRING_H

#include <iostream.h>
#include <string.h>
#include <assert.h>

class MyString
{
	public:
		MyString(unsigned int l=0);
		MyString(const char* c);
		MyString(const MyString&);
		char getCharAt(unsigned int i) const;
		void setCharAt(unsigned int i, char c);
		void print() const;
		char* toCharArray(char*) const;
		void append(const MyString& s);
		int getLength() const;
		~MyString();

		const MyString& operator=(const MyString& m);
		bool operator==(const MyString& m) const;
		bool operator<=(const MyString& m) const;
		bool operator<(const MyString& m) const;
		bool operator>=(const MyString& m) const;
		bool operator>(const MyString& m) const;
		char operator()(unsigned int) const;
		char operator[](unsigned int) const;
		const MyString& operator+=(const MyString& m);
		friend ostream& operator<<(ostream& o, const MyString& m);

		//Funziona solo se la stringa letta ha dimensione inferiore a m.length
		friend istream& operator>>(istream& i, MyString& m);

	private:
		char* str;
		unsigned int length;
};

#endif