#include "Mailer.h"

/**
 *  Se esite gia' una email con lo stesso ID
 *  restituisce -1 senza inserirla
 *
 *  Altrimenti la inserisce (push_back) e restituisce il numero
 *  di email gia' inserite aventi lo stesso messaggio
 *  e diverso mittente
 *
 *  Chiaramente se la lista e' vuota
 *  inserisce e restituisce 0
 */
int Solution::aggiungiEmail(Email c)
{
    int count = 0;
    for(list<Email>::iterator it = emails.begin(); it != emails.end(); it++)
    {
        if((*it) == c)
            return -1;
        else if((*it).getMessaggio() == c.getMessaggio() &&
                (*it).getMittente() != c.getMittente())
            count ++;
    }
    emails.push_back(c);
    return count;
}

/**
 *  Restituisce true se e solo se esistono almeno due email
 *  aventi tutti i campi uguali (mittente, destinatario,
 *  messaggio, dataInvio e numeroAllegati) tranne l'ID.
 *
 *  Se la lista e' vuota restituisce false
 */
bool Solution::esisteClone()
{
    for(list<Email>::iterator it1 = emails.begin(); it1 != emails.end(); it1++)
        for(list<Email>::iterator it2 = emails.begin(); it2 != emails.end(); it2++)
            if((*it1).getID() != (*it2).getID() &&
               (*it1).getDataInvio() == (*it2).getDataInvio() &&
               (*it1).getDestinatario() == (*it2).getDestinatario() &&
               (*it1).getMessaggio() == (*it2).getMessaggio() &&
               (*it1).getMittente() == (*it2).getMittente() &&
               (*it1).getNumeroAllegati() == (*it2).getNumeroAllegati())
                    return true;
    return false;
}

/**
 *  Cerca l'email "piu' vecchia" (in base a 'dataInvio') avente
 *  il mittente specificato e ne restituisce la posizione
 *  nella lista (la prima email ha posizione 0).
 *
 *  In caso di exequo (due email nello stesso istante
 *  con lo stesso mittente) restituisce la posizione di quella
 *  inserita per prima nella lista
 *
 *  Se non esiste alcuna email avente il mittente specificato
 *  o se la lista e' vuota restituisce -1
 */
int Solution::cercaEmail(string mitt)
{
    int pos = 0;
    int data = INT_MAX;
    int returnPos = -1;
    for(list<Email>::iterator it1 = emails.begin(); it1 != emails.end(); it1++,pos++)
        if((*it1).getMittente() == mitt)
            if((*it1).getDataInvio() < data)
            {
                data = (*it1).getDataInvio();
                returnPos = pos;
            }
    return returnPos;
}

/**
 *  Verifica se il numero di mittenti distinti
 *  e' uguale al numero di destinatari distinti
 *
 *  Se non vi sono email restituisce false
 */
bool Solution::verificaMittDest()
{
    if(emails.size() == 0)
        return false;

    list<string> mitt;
    list<string> dest;
    for(list<Email>::iterator it1 = emails.begin(); it1 != emails.end(); it1++)
    {
        bool inseritoM = false;
        for(list<string>::iterator im = mitt.begin(); im != mitt.end() && !inseritoM; im++)
            if((*im) == (*it1).getMittente())
                inseritoM = true;
        if(!inseritoM)
            mitt.push_back((*it1).getMittente());

        bool inseritoD = false;
        for(list<string>::iterator id = dest.begin(); id != dest.end() && !inseritoD; id++)
            if((*id) == (*it1).getDestinatario())
                inseritoD = true;
        if(!inseritoD)
            dest.push_back((*it1).getDestinatario());
    }

    return mitt.size() == dest.size();
}


/**
 *  Restituisce il mittente che ha scritto
 *  piu' email in assoluto.
 *  In caso di parita' (piu' mittenti in exequo)
 *  restituisce quello che compare per ultimo nella lista
 *
 *  se la lista e' vuota restituisce "NULL"
 */
string Solution::migliorMittente()
{
    int maxNum = 0;
    string mitt = "NULL";
    for(list<Email>::iterator it1 = emails.begin(); it1 != emails.end(); it1++)
    {
        int count = 0;
        for(list<Email>::iterator it2 = it1; it2 != emails.end(); it2++)
            if(!(it1 == it2) && (*it1).getMittente() == (*it2).getMittente())
                count++;
        if(count >= maxNum)
        {
            maxNum = count;
            mitt = (*it1).getMittente();
        }
    }
    return mitt;
}

