#ifndef MAILER_H
#define MAILER_H

#include "Email.h"
#include <cstdlib>
#include <iostream>
#include <list>
using namespace std;

class Mailer
{

private:
	list<Email> emails;

public:

    /**
     *  Se esite gia' una email con lo stesso ID
     *  restituisce -1 senza inserirla
     *
     *  Altrimenti la inserisce (push_back) e restituisce il numero
     *  di email gia' inserite aventi lo stesso messaggio
     *  e diverso mittente
     *
     *  Chiaramente se la lista e' vuota
     *  inserisce e restituisce 0
     */
    int aggiungiEmail(Email em);

	/**
	 *  Restituisce true se e solo se esistono almeno due email
	 *  aventi tutti i campi uguali (mittente, destinatario,
	 *  messaggio, dataInvio e numeroAllegati) tranne l'ID.
	 *
	 *  Se la lista e' vuota restituisce false
	 */
	bool esisteClone();

	/**
	 *  Cerca l'email "piu' vecchia" (in base a 'dataInvio') avente
	 *  il mittente specificato e ne restituisce la posizione
	 *  nella lista (la prima email ha posizione 0).
	 *
	 *  In caso di exequo (due email nello stesso istante
     *  con lo stesso mittente) restituisce la posizione di quella
     *  inserita per prima nella lista
	 *
	 *  Se non esiste alcuna email avente il mittente specificato
	 *  restituisce -1
	 */
	int cercaEmail(string mitt);

	/**
	 *  Verifica se il numero di mittenti distinti
	 *  e' uguale al numero di destinatari distinti
	 *
	 *  Se non vi sono email restituisce false
	 */
	bool verificaMittDest();

	/**
	 *  Restituisce il mittente che ha scritto
	 *  piu' email in assoluto.
	 *  In caso di parita' (piu' mittenti in exequo)
	 *  restituisce quello che compare per ultimo nella lista
	 *
	 *  se la lista e' vuota restituisce "NULL"
	 */
	string migliorMittente();

	inline list<Email>& getContent();
};

list<Email>& Mailer::getContent()
{
    return emails;
}

#endif
