#include "Campionato.h"

list<Nuotatore> haVintoInAlmenoDueSpecialita(const Campionato& C);
Ruolo intToRuolo(int i);
void inserisciSeNonPresente(list<Nuotatore>& l, const Nuotatore& n);

list<Nuotatore> haVintoInAlmenoDueSpecialita2(const Campionato& C);

int main()
{
    return 0;
}

// versione con for
list<Nuotatore> haVintoInAlmenoDueSpecialita(const Campionato& C)
{
    list<Nuotatore> result;

    for(int i = 0; i < 4; i++)
    {
        Ruolo r1 = intToRuolo(i);
        list<Nuotatore>& c1 = C.classificaFinale(r1);
        Nuotatore n1 = *c1.begin();

        for(int j = i+1; j < 4; j++)
        {
            Ruolo r2 = intToRuolo(j);
            list<Nuotatore>& c2 = C.classificaFinale(r2);
            Nuotatore n2 = *c2.begin();
            
            if(n1.ottieniNome() == n2.ottieniNome() && n1.ottieniCognome() == n2.ottieniCognome())
                inserisciSeNonPresente(result, n1);
        }
    }
    
    return result;
}

Ruolo intToRuolo(int i)
{
    switch(i)
    {
    case 0:
        return STILE;
        
    case 1:
        return RANA;
        
    case 2:
        return DELFINO;
        
    case 4:
        return TUFFI;
    }
}

void inserisciSeNonPresente(list<Nuotatore>& l, const Nuotatore& n)
{
    for(list<Nuotatore>::const_iterator it = l.begin(); it != l.end(); it++)
        if(it->ottieniNome() == n.ottieniNome() && it->ottieniCognome() == n.ottieniCognome())
            return;
            
    l.push_back(n);
}

// versione senza for
list<Nuotatore> haVintoInAlmenoDueSpecialita2(const Campionato& C)
{
    list<Nuotatore>& c1 = C.classificaFinale(STILE);
    list<Nuotatore>& c2 = C.classificaFinale(RANA);
    list<Nuotatore>& c3 = C.classificaFinale(DELFINO);
    list<Nuotatore>& c4 = C.classificaFinale(TUFFI);

    Nuotatore n1 = *c1.begin();
    Nuotatore n2 = *c2.begin();
    Nuotatore n3 = *c3.begin();
    Nuotatore n4 = *c4.begin();

    list<Nuotatore> result;
    
    if(n1.ottieniNome() == n2.ottieniNome() && n1.ottieniCognome() == n2.ottieniCognome()
        || n1.ottieniNome() == n3.ottieniNome() && n1.ottieniCognome() == n3.ottieniCognome()
        || n1.ottieniNome() == n4.ottieniNome() && n1.ottieniCognome() == n4.ottieniCognome())
        inserisciSeNonPresente(result, n1);
    
    if( n2.ottieniNome() == n3.ottieniNome() && n2.ottieniCognome() == n3.ottieniCognome()
        || n2.ottieniNome() == n4.ottieniNome() && n2.ottieniCognome() == n4.ottieniCognome())
        inserisciSeNonPresente(result, n2);
    
    if( n3.ottieniNome() == n4.ottieniNome() && n3.ottieniCognome() == n4.ottieniCognome())
        inserisciSeNonPresente(result, n3);
    
    return result;
}


