#include "PilaPerPrimaIVincitori.h"

#include <cassert>

PilaPerPrimaIVincitori::PilaPerPrimaIVincitori(const Campionato& c)
    : campionato(c)
{
}
    
void PilaPerPrimaIVincitori::push(const Nuotatore& n)
{
    for(list<Nuotatore>::iterator it = list<Nuotatore>::begin();
        it != list<Nuotatore>::end(); it++)
    {
        if(numeroVittorie(n) > numeroVittorie(*it))
        {
            list<Nuotatore>::insert(it, n);
            return;
        }
    }
    
    list<Nuotatore>::push_back(n);
}

Nuotatore PilaPerPrimaIVincitori::pop()
{
    assert(!isEmpty());
    
    Nuotatore n = list<Nuotatore>::front();
    list<Nuotatore>::pop_front();
    return n;
}

int PilaPerPrimaIVincitori::size() const
{
    return list<Nuotatore>::size();
}

bool PilaPerPrimaIVincitori::isEmpty() const
{
    return list<Nuotatore>::empty();
}

int PilaPerPrimaIVincitori::numeroVittorie(const Nuotatore& n) const
{
    int count = 0;
    
    for(int i = 0; i < 4; i++)
    {
        Ruolo r1 = intToRuolo(i);
        list<Nuotatore>& c1 = C.classificaFinale(r1);
        Nuotatore n1 = *c1.begin();
        if(n1.ottieniNome() == n.ottieniNome() && n1.ottieniCognome() == n.ottieniCognome())
            count++;
    }
    
    return count;
}

