#ifndef MULTINAZIONALE_H
#define MULTINAZIONALE_H

#include "Venditore.h"

class Multinazionale
{
private:
    list<Venditore> venditori;
    list<Prodotto> prodotti;
    
public:
    const list<Venditore>& getVenditori() const;
    const list<Prodotto>& getProdotti() const;

    list<Venditore>& getVenditori();
    list<Prodotto>& getProdotti();
    
    // (a) determinare il numero di prodotti venduti di un certo tipo 
    int numeroProdottiVenduti(TipoProdotto tipoProdotto) const;
    
    // (b) determinare il prodotto più venduto 
    Prodotto prodottoPiuVenduto() const;
    
    // (c) ordinare i prodotti in base alle vendite 
    void ordinaProdottiInBaseAlleVendite();
    
    // (d) costruire un elenco ordinato di venditori in base alle vendite effettuate 
    list<Venditore> costruisciElencoVenditoriOrdinatoInBaseAlleVendite() const;
    
    // (e) determinare il prodotto e il punto vendita con la resa maggiore (maggiori ricavi)
    Prodotto determinaProdottoConResaMaggiore() const;
    Venditore determinaVenditoreConResaMaggiore() const;
};

#endif

