#include "Urna.h"

/*
bool Urna::aggiungiVoto(Voto v)
{
    if(voti.size() % 3 >= 1)
    {
        Voto ultima, penultima;
        for(list<Voto>::const_iterator it = voti.begin(); it != voti.end(); it++)
        {
            penultima = ultima;
            ultima = *it;
        }
 
        if(v.dammiTipo() == ultima.dammiTipo())
            return false;
 
        if(voti.size() % 3 == 2 && v.dammiTipo() == penultima.dammiTipo())
            return false;
    }
 
    voti.push_back(v);
    return true;
}
*/
bool Urna::aggiungiVoto(Voto v)
{
	Voto ultima, penultima;
	list<Voto>::const_reverse_iterator it = voti.rbegin();	

	if(voti.size() % 3 >= 1)
	{
		ultima = *it;
		if(v.dammiTipo() == ultima.dammiTipo())
			return false;
	}
	if(voti.size() % 3 == 2)
	{
		it++;
		penultima = *it;
		if(v.dammiTipo() == penultima.dammiTipo())
			return false;
	}

	voti.push_back(v);
	return true;
}

bool Urna::maggioranzaVotiNulli(Tipo t)
{
	int count[3];
	count[SENATO] = count[CAMERA] = count[REGIONE] = 0;

	for(list<Voto>::const_iterator c = voti.begin(); c != voti.end(); c++)
		if(c->dimmiSeNullo())
			count[c->dammiTipo()]++;

	return count[t] >= count[0] && count[t] >= count[1] && count[t] >= count[2];
}

list<string> Urna::coalizioniVincenti(Tipo t)
{
	list<string> vincenti;
	int max = 0;
	for(list<Voto>::const_iterator c = voti.begin(); c != voti.end(); c++)
	{
		if(c->dammiTipo() == t && !c->dimmiSeNullo() && c->dammiCoalizione() != "")
		{
			int count = 0;
			for(list<Voto>::const_iterator c1 = c; c1 != voti.end(); c1++)
				if(c1->dammiTipo() == t && !c1->dimmiSeNullo() && c1->dammiCoalizione() == c->dammiCoalizione())
					count++;

			if(count > max)
			{
				max = count;
				vincenti.erase(vincenti.begin(), vincenti.end());  // vincenti = list<string>();
				vincenti.push_back(c->dammiCoalizione());
			}
			else if(count == max)
				vincenti.push_back(c->dammiCoalizione());
		}
	}

	return vincenti;
}
/*
list<string> Urna::coalizioniVincenti(Tipo t)
{
	vector<string> coalizioni;
	vector<int> numPref;
 
	for(list<Voto>::const_iterator it = voti.begin(); it != voti.end(); it++)
	{
		Voto v = *it;
		if(v.dammiTipo() == t && !v.dimmiSeNullo() && v.dammiCoalizione() != "")
		{
			bool trovato = false;
			for(int i = 0; i < coalizioni.size(); i++)
				if(coalizioni[i] == v.dammiCoalizione())
				{
					numPref[i]++;
					trovato = true;
				}
 
			if(!trovato)
			{
				coalizioni.push_back(v.dammiCoalizione());
				numPref.push_back(1);
			}
 
		}
	}
 
    list<string> vincenti;
	int max = 0;
	for(int i = 0; i < coalizioni.size(); i++)
		if(numPref[i] > max)
		{
			max = numPref[i];
			vincenti.erase(vincenti.begin(), vincenti.end());
			vincenti.push_back(coalizioni[i]);
		}
		else if(numPref[i] == max)
			vincenti.push_back(coalizioni[i]);
 
	return vincenti;
}
*/


list<string> Urna::coalizioniConSequenzePiuLunghe(Tipo t)
{
	list<string> vincenti;
	int max = 0;
	for(list<Voto>::const_iterator c = voti.begin(); c != voti.end(); c++)
	{
		if(c->dammiTipo() == t && !c->dimmiSeNullo() && c->dammiCoalizione() != "")
		{
			int count = 0;
			for(list<Voto>::const_iterator c1 = c; c1 != voti.end(); c1++)
			{
			    if(c1->dammiTipo() == t && !c1->dimmiSeNullo())
			    {
    				if(c1->dammiCoalizione() == c->dammiCoalizione())
    	    			count++;
	    			else
	    			    break;
			    }
			}

			if(count > max)
			{
				max = count;
				vincenti.erase(vincenti.begin(), vincenti.end());  // vincenti = list<string>();
				vincenti.push_back(c->dammiCoalizione());
			}
			else if(count == max)
				vincenti.push_back(c->dammiCoalizione());
		}
	}

	return vincenti;
}

