#ifndef URNA_H
#define URNA_H

#include "Voto.h"
#include <cstdlib>
#include <iostream>
#include <list>
using namespace std;

/* 

Questa classe modella un'URNA contente solo schede votate.
Assumiamo che un oggetto di tipo Voto rappresenti una scheda votata,
che puo' essere anche nulla o bianca (come specificato nella documentazione
della classe Voto).
Quindi, l'urna sara' rappresentata da una lista di istanze della classe Voto
(nello specifico, la lista "voti").

I voti sono esattamente di 3 tipi,
come specificato nella classe Voto (senato, camera e regione).

Ogni elettore *deve* votare tutte e tre le schede, ma l'ordine in cui 
le tre schede votate (ovvero i tre oggetti di tipo Voto) vengono 
inserite nell'urna e' a sua discrezione.
Di conseguenza, dopo che un elettore ha votato e inserito tutte
e tre le schede nell'urna, la dimensione dell'urna sara' un multiplo di 3
(nello specifico, 3 moltiplicato il numero di elettori che hanno votato).

Ad esempio, dopo quattro votanti, il tipo delle schede presenti nell'urna 
potrebbe essere il seguente:

Urna = [CAMERA,     REGIONE,    SENATO, 
        SENATO,     CAMERA,     REGIONE, 
        SENATO,     REGIONE,    CAMERA,
        CAMERA,     SENATO,     REGIONE ]

Si richiede di implementare nel file Urna.cpp
tutti i metodi di questa classe ad eccezione del costruttore
(la cui implementazione e' data e non puo' essere modificata).

 */
class Urna // questa riga e' corretta NON MODIFICARE
{

private:
    // Le schede dell' URNA sono memorizzate in una lista.
    list<Voto> voti;

public:

    /*
    
    Questo metodo aggiunge una scheda all'urna solo se non viola la suddetta struttura dell'urna.
    In questo caso, il metodo ritorna true.
    Altrimenti, se la proprieta' non e' soddisfatta, restituisce false senza inserire la scheda.

    Ad esempio, se il tipo delle schede nell'urna e' il seguente:

    Urna = [SENATO,     CAMERA,     REGIONE,
            REGIONE ]

    il metodo restituira' true solo se la scheda e' di tipo CAMERA o SENATO.

    */
    bool aggiungiVoto(Voto v);

    /*

    Dato un Tipo, il metodo restituisce true se e solo se la maggioranza
    delle schede nulle e' di quel tipo.
    Ad esempio, se l'urna contenesse i seguenti voti:

    Urna = [("Coal1", CAMERA,  true),  ("Coal1", REGIONE, false), ("Coal2", SENATO, false), 
            ("Coal1", REGIONE, true),  ("Coal2", CAMERA,  false), ("",      SENATO, false), 
            ("Coal2", CAMERA,  true),  ("Coal1", REGIONE, false), ("Coal2", SENATO, false) ]

    il metodo "maggioranzaVotiNulli(CAMERA)"  restituirebbe true  (due nulle),
    il metodo "maggioranzaVotiNulli(REGIONE)" restituirebbe false (una nulla),
    il metodo "maggioranzaVotiNulli(SENATO)"  restituirebbe false (zero nulle).

    */
    bool maggioranzaVotiNulli(Tipo t);

    /*

    Dato un Tipo, restituire la lista di coalizione con piu' voti per quel Tipo.
    Se piu' di una coalizione risulta vincente, la lista deve essere costruita
    dando priorita' alla coalizione che per prima ha preso un voto valido.
    Ad esempio, se l'urna contenesse i seguenti voti:

    Urna = [("Coal1", CAMERA,  false), ("Coal1", REGIONE, false), ("Coal2", SENATO, false), 
            ("Coal1", REGIONE, true),  ("Coal2", CAMERA,  false), ("",      SENATO, true), 
            ("Coal2", CAMERA,  false), ("Coal1", REGIONE, false), ("Coal2", SENATO, false), 
            ("",      SENATO,  false), ("Coal1", REGIONE, true),  ("Coal1", CAMERA, true),
            ("Coal1", CAMERA,  false), ("Coal1", REGIONE, false), ("Coal2", SENATO, false) ]

    il metodo "coalizioniVincenti(CAMERA)" restituirebbe ["Coal1", "Coal2"] in quest'ordine. 
    Infatti, "Coal1" ha due voti validi (righe 1 e 5; la riga 4 ha un voto nullo).
    Allo stesso modo, "Coal2" ha due voti validi (righe 2 e 3).
    "Coal1" precede "Coal2" nella lista restituita in quanto il primo voto valido
    di "Coal1" e' sulla riga 1, mentre per "Coal2" e' sulla riga 2.

     */
    list<string> coalizioniVincenti(Tipo t);

    /*

    Dato un Tipo, restituire la lista di coalizione con piu' voti consecutivi per quel Tipo.
    Se piu' di una coalizione soddisfa la condizione, la lista deve essere costruita
    dando priorita' alla coalizione che per prima ha preso un voto valido.
    Ad esempio, se l'urna contenesse i seguenti voti:

    Urna = [("Coal1", CAMERA,  false), ("Coal1", REGIONE, false), ("Coal2", SENATO, false), 
            ("Coal1", REGIONE, true),  ("Coal2", CAMERA,  false), ("",      SENATO, true), 
            ("Coal2", CAMERA,  false), ("Coal1", REGIONE, false), ("Coal2", SENATO, false), 
            ("",      SENATO,  false), ("Coal1", REGIONE, true),  ("Coal1", CAMERA, true),
            ("Coal1", CAMERA,  false), ("Coal1", REGIONE, false), ("Coal2", SENATO, false) ]

    il metodo "coalizioniConSequenzePiuLunghe(CAMERA)" restituirebbe ["Coal2"]. 
    Infatti, "Coal1" compare in due sequenze di lunghezza 1: la prima in riga 1, 
    la seconda in riga 5 (da notare che il voto per "Coal1" in riga 4 e' nullo).
    "Coal2", invece, compare in una sola lista di lunghezza 2: da riga 2 a riga 3.
    Non essendoci altre coalizzioni votate alla CAMERA, "Coal2" risulta essere
    la sola coalizione con la sequenza piu' lunga di voti consecutivi alla CAMERA.

    */

    list<string> coalizioniConSequenzePiuLunghe(Tipo t);

    inline list<Voto>& getContent();
};

list<Voto>& Urna::getContent()
{
    return voti;
}

#endif
