#ifndef VOTO_H_
#define VOTO_H_

#include<string>
using namespace std;

enum Tipo { SENATO = 0, CAMERA, REGIONE };

/*

Un oggetto di tipo Voto rappresenta l'espressione di una preferenza di un elettore
su una delle tre possibili schede: SENATO, CAMERA e REGIONE.

Se il flag "nullo" e' true, allora il voto e' nullo.

Se "coalizione" e' la stringa vuota, allora il voto equivale ad una scheda bianca
(chiaramente cio' vale solo se il flag "nullo" e' false; se fosse true la scheda
sarebbe nulla indipendentemente dal campo "coalizione").

Questa classe e' gia' implementata e non necessita di modifiche.
Eventuali metodi accessori sono comunque ammessi.

*/
class Voto
{
private:
	string coalizione;
	Tipo tipo;
	bool nullo;

public:
	Voto(string ="", Tipo = SENATO, bool = false);

	string dammiCoalizione() const;
	Tipo dammiTipo() const;
	bool dimmiSeNullo() const;

	void impostaCoalizione(string);
	void impostaTipo(Tipo);
	void impostaNullo(bool);

	bool operator==(const Voto&) const;
};

#endif
