package saw.junit.auction;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

import saw.junit.auction.intf.Seller;

/**
 * 
 * @author gio
 *
 */
public class AuctionItem {
	private static AtomicLong nextId=new AtomicLong(1);
	
	

	public static AuctionItem createAuctionItem(
			String description, int condition, Date ends) {
		return new AuctionItem(nextId.getAndIncrement(), description, condition, ends);
	}

	private Long number;
	
	private String description;
	private String shortDescription;
	private List<Bid> bids;
	private Bid successfulBid;
	private Seller seller;
	private Date ends;
	private int condition;

	public List<Bid> getBids() {
		return bids;
	}

	public String getDescription() {
		return description;
	}

	public Seller getSeller() {
		return seller;
	}
	
	/**
	 * @param seller the seller to set
	 */
	public void setSeller(Seller seller) {
		this.seller = seller;
	}

	public Bid getSuccessfulBid() {
		return successfulBid;
	}


	public void setDescription(String string) {
		description = string;
	}



	public Date getEnds() {
		return ends;
	}


	public int getCondition() {
		return condition;
	}


	/**
	 * @param l 
	 * @param description
	 * @param condition
	 * @param ends
	 */
	private AuctionItem(long number, String description, int condition, Date ends) {
		super();
		this.number=number;
		this.description = description;
		this.condition = condition;
		this.ends = ends;
		this.bids=new ArrayList<Bid>();
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((number == null) ? 0 : number.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		AuctionItem other = (AuctionItem) obj;
		if (number == null) {
			if (other.number != null)
				return false;
		} else if (!number.equals(other.number))
			return false;
		return true;
	}

	public String toString() {
		return shortDescription + " (" + description + ": " + condition
				+ "/10)";
	}

	public String getShortDescription() {
		return shortDescription;
	}

	public void setShortDescription(String shortDescription) {
		this.shortDescription = shortDescription;
	}

	

	/**
	 * @return the number
	 */
	public Long getNumber() {
		return number;
	}

}
