/**
 * 
 */
package saw.junit.auction;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import saw.junit.auction.exception.AuctionAlreadyOnlineException;
import saw.junit.auction.exception.AuctionClosedException;
import saw.junit.auction.exception.AuctionNotFoundException;
import saw.junit.auction.exception.AuctionServiceException;
import saw.junit.auction.intf.Seller;

/**
 * @author gio
 * 
 */
public class AuctionService {

	private static AuctionService auctionService;

	public static AuctionService connect() {
		
		if (auctionService == null)
			auctionService = new AuctionService();
		return auctionService;
	}
	
	public void disconnect() {
		
		auctionService=null;
	}

	private final List<AuctionItem> currentAuctions;

	/**
	 * 
	 */
	private AuctionService() {
		super();
		currentAuctions = new ArrayList<AuctionItem>();
	}

	public void publishAuction(AuctionItem auction, Seller seller)
			throws AuctionAlreadyOnlineException {

		if (currentAuctions.contains(auction))
			throw new AuctionAlreadyOnlineException("Item Already published "
					+ auction);

		auction.setSeller(seller);
		seller.getAuctions().add(auction);
		currentAuctions.add(auction);

	}

	public Iterable<AuctionItem> viewAuctions() {
		return currentAuctions;
	}

	public boolean placeBidOnItem(Bid bid, AuctionItem auction)
			throws AuctionNotFoundException, AuctionClosedException {

		checkIsOnLine(auction);

		auction.getBids().add(bid);

		return true;
	}

	/**
	 * @param item
	 * @throws AuctionNotFoundException
	 * @throws AuctionClosedException
	 * @throws AuctionServiceException
	 */
	private void checkIsOnLine(AuctionItem item)
			throws AuctionNotFoundException, AuctionClosedException {
		if (!currentAuctions.contains(item))
			throw new AuctionNotFoundException("Item not found " + item);
		if (isClosed(item))
			throw new AuctionClosedException("Auction closed " + item);
	}

	private boolean isClosed(AuctionItem auctionItem) {
		return auctionItem.getEnds().before(new Date());
	}

}
