package saw.junit.auction;


import java.util.Date;

import saw.junit.auction.intf.Bidder;

/**
 * @author Gavin King
 */
public class Bid  {
	
	
	/**
	 * @param item
	 * @param amount
	 * @param bidder
	 * @param datetime
	 */
	public Bid(AuctionItem item, float amount, Bidder bidder, Date datetime) {
		super();
		this.item = item;
		this.amount = amount;
		this.bidder = bidder;
		this.datetime = datetime;
		bidder.getBids().add(this);
	}
	private AuctionItem item;
	private float amount;
	private Date datetime;
	private Bidder bidder;
	
	public AuctionItem getItem() {
		return item;
	}


	public float getAmount() {
		return amount;
	}

	public Date getDatetime() {
		return datetime;
	}


	public Bidder getBidder() {
		return bidder;
	}


	public String toString() {
		return bidder.getUserName() + " $" + amount;
	}
	


	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + Float.floatToIntBits(amount);
		result = prime * result + ((bidder == null) ? 0 : bidder.hashCode());
		result = prime * result
				+ ((datetime == null) ? 0 : datetime.hashCode());
		result = prime * result + ((item == null) ? 0 : item.hashCode());
		
		return result;
	}


	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Bid other = (Bid) obj;
		if (Float.floatToIntBits(amount) != Float.floatToIntBits(other.amount))
			return false;
		if (bidder == null) {
			if (other.bidder != null)
				return false;
		} else if (!bidder.equals(other.bidder))
			return false;
		if (datetime == null) {
			if (other.datetime != null)
				return false;
		} else if (!datetime.equals(other.datetime))
			return false;
		if (item == null) {
			if (other.item != null)
				return false;
		} else if (!item.equals(other.item))
			return false;
		return true;
	}

}
