package saw.junit.auction;


import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import saw.junit.auction.intf.Bidder;
import saw.junit.auction.intf.Seller;

/**
 * @author Gavin King
 */
public class User implements Seller,Bidder{
	
	private String userName;
	private String password;
	private String email;
	private Name name;
	private List<Bid> bids;
	private List<AuctionItem> auctions;
	
	/**
	 * @param name
	 * @param userName
	 * @param password
	 * @param email
	 */
	public User(Name name, String userName, String password, String email) {
		this.email = email;
		this.name = name;
		this.password = password;
		this.userName = userName;
		bids=new ArrayList<Bid>();
		auctions=new ArrayList<AuctionItem>();
	}

	

	public String getEmail() {
		return email;
	}

	public String getPassword() {
		return password;
	}

	public String getUserName() {
		return userName;
	}

	public Collection<AuctionItem> getAuctions() {
		return auctions;
	}

	public Collection<Bid> getBids() {
		return bids;
	}
	public String toString() {
		return userName;
	}

	public Name getName() {
		return name;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((userName == null) ? 0 : userName.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		User other = (User) obj;
		if (userName == null) {
			if (other.userName != null)
				return false;
		} else if (!userName.equals(other.userName))
			return false;
		return true;
	}


}
