/**
 * 
 */
package saw.junit.auction.test;

import static org.junit.Assert.fail;

import java.util.Date;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import saw.junit.auction.AuctionItem;
import saw.junit.auction.AuctionService;
import saw.junit.auction.Bid;
import saw.junit.auction.Name;
import saw.junit.auction.User;
import saw.junit.auction.exception.AuctionAlreadyOnlineException;
import saw.junit.auction.exception.AuctionClosedException;
import saw.junit.auction.exception.AuctionNotFoundException;
import saw.junit.auction.exception.AuctionServiceException;

/**
 * @author gio
 *
 */
public class AuctionServiceTest {

	private static AuctionService auctionService;

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		
		auctionService=AuctionService.connect();
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
		
		auctionService.disconnect();
	}

	private User testUser;

	@Before
	public void setUp() throws Exception {
		 testUser = new User(new Name("Pinco","Pallino"),"pinco","psw","pinco@pinco.it");
	}

	@After
	public void tearDown() throws Exception {
	}

	/**
	 * Test method for {@link saw.junit.auction.AuctionService#connect()}.
	 */
	@Test(timeout=1)
	public void testConnect() {
		auctionService.connect();
	}

	/**
	 * Test method for {@link saw.junit.auction.AuctionService#disconnect()}.
	 */
	@Test
	public void testDisconnect() {
		fail("Not yet implemented");
	}

	/**
	 * Test method for {@link saw.junit.auction.AuctionService#publishAuction(saw.junit.auction.AuctionItem, saw.junit.auction.intf.Seller)}.
	 * @throws AuctionServiceException 
	 */
	@Test(expected=AuctionServiceException.class)
	public void testPublishAuction() throws AuctionServiceException {
		
		AuctionItem auctionItem = AuctionItem.createAuctionItem("car", 50, TestUtils.date(2008, 11, 1));
//		Seller seller=new User(new Name("Pinco","Pallino"),"pinco","psw","pinco@pinco.it");
		auctionService.publishAuction(auctionItem, testUser);
		auctionService.publishAuction(auctionItem, testUser);
	}

	/**
	 * Test method for {@link saw.junit.auction.AuctionService#viewAuctions()}.
	 */
	@Test
	public void testViewAuctions() {
		fail("Not yet implemented");
	}

	/**
	 * Test method for {@link saw.junit.auction.AuctionService#placeBidOnItem(saw.junit.auction.Bid, saw.junit.auction.AuctionItem)}.
	 * @throws AuctionClosedException 
	 * @throws AuctionNotFoundException 
	 */
	@Test(expected=AuctionNotFoundException.class)
	public void testPlaceBidOnItem() throws AuctionNotFoundException, AuctionClosedException {
		
		AuctionItem auctionItem = AuctionItem.createAuctionItem("car", 50, TestUtils.date(2008, 11, 1));
		Bid bid=new Bid(auctionItem,50f,testUser,new Date());
		auctionService.placeBidOnItem(bid, auctionItem);
	}
	
	/**
	 * Test method for {@link saw.junit.auction.AuctionService#placeBidOnItem(saw.junit.auction.Bid, saw.junit.auction.AuctionItem)}.
	 * @throws AuctionClosedException 
	 * @throws AuctionNotFoundException 
	 * @throws AuctionAlreadyOnlineException 
	 */
	@Test(expected=AuctionClosedException.class)
	public void testPlaceBidOnItem2() throws AuctionNotFoundException, AuctionClosedException, AuctionAlreadyOnlineException {
		
		AuctionItem auctionItem = AuctionItem.createAuctionItem("car", 50, TestUtils.date(2007, 11, 1));
		auctionService.publishAuction(auctionItem, testUser);
		Date now = new Date();
		Bid bid=new Bid(auctionItem,50f,testUser,now);
		auctionService.placeBidOnItem(bid, auctionItem);
	}

}
