package saw.junit.auction.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.Date;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import saw.junit.auction.AuctionItem;
import saw.junit.auction.AuctionService;
import saw.junit.auction.Bid;
import saw.junit.auction.Name;
import saw.junit.auction.User;
import saw.junit.auction.exception.AuctionServiceException;
import saw.junit.auction.intf.Seller;

public class UserTest {

	private static AuctionService auctionService;

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		
		auctionService=AuctionService.connect();
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
		
		auctionService.disconnect();
	}

	private User testUser;

	@Before
	public void setUp() throws Exception {
		 testUser = new User(new Name("Pinco","Pallino"),"pinco","psw","pinco@pinco.it");
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void testEqualsAndHashCode() {
		
		
		User copy=new User(new Name("Pinco","Pallino"),"pinco","psw","pinco@pinco.it");
		
		assertEquals("Must be equals", testUser, copy);
		assertTrue("Same hashcode",testUser.hashCode()==copy.hashCode());
	}
	
	@Test
	public void testAddAuction() throws AuctionServiceException {
			
		AuctionItem auctionItem = AuctionItem.createAuctionItem("car", 50, TestUtils.date(2008, 11, 1));
//		Seller seller=new User(new Name("Pinco","Pallino"),"pinco","psw","pinco@pinco.it");
		auctionService.publishAuction(auctionItem, testUser);
		assertTrue("Auction must be contained in the seller's auction list",testUser.getAuctions().contains(auctionItem));
	}
	
	@Test
	public void testCreateBid() throws AuctionServiceException {
			
		AuctionItem auctionItem = AuctionItem.createAuctionItem("car", 50, TestUtils.date(2008, 11, 1));
		Bid bid=new Bid(auctionItem,10f,testUser,new Date());
		assertTrue("Bid must be contained in the bidder's bid list",testUser.getBids().contains(bid));
	}
	

}
