package saw.reflection.beanInfo;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;

public class PersonBean{
	private final String beanName = "PersonBean";
	private int age;
	private boolean bad;
	private String name;
	private Gender gender;

	public String getName() {
		return this.name;
	}

	public int getAge() {
		return age;
	}

	public void setAge(int age) {
		this.age = age;
	}

	public Gender getGender() {
		return gender;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getSize() {
		return this.age;
	}

	public void setSize(int size) {
		this.age = size;
	}

	public boolean isBad() {
		return bad;
	}

	public static void main(String[] args) throws IntrospectionException {
		// get the bean info and remove info inherited from Objcet class
		BeanInfo info = Introspector
				.getBeanInfo(PersonBean.class, Object.class);
		// info.getMethodDescriptors()
		System.out.println("Properties:");
		for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
			System.out.println("property: " + pd.getName());
			System.out.println("   of type: " + pd.getPropertyType());
			System.out.println("   can be read with method: "
					+ pd.getReadMethod());
			System.out.println("   can be written with method :"
					+ pd.getWriteMethod());
		}

		System.out.println("Methods:");
		for (MethodDescriptor md : info.getMethodDescriptors()) {
			System.out.println("name: " + md.getName());
			System.out.println("   method: " + md.getMethod());
		}

	}
}
