package saw.reflection.fieldModification;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

/**
 * Demonstrates how to set public field objects.
 * 
 * @author gio
 * 
 */
public class FieldModification {

	/**
	 * Sets all public int fields in an object to a given value.
	 * 
	 * @param obj
	 *            The object to operate on.
	 * @param valueToSet
	 * @throws IllegalAccessException
	 * @throws IllegalArgumentException
	 * 
	 * 
	 */
	public static void modifyPublicIntFields(final Object obj, int valueToSet)
			throws IllegalArgumentException, IllegalAccessException {

		final Integer value = new Integer(valueToSet);
		Field[] fields = obj.getClass().getFields();
		for (int idx = 0; idx < fields.length; idx++) {
			if (fields[idx].getType() == int.class) {
				fields[idx].set(obj, value);
			}
		}

	}

	public static void modifyPrivateIntFields(final Object obj, int valueToSet)
			throws IllegalArgumentException, IllegalAccessException {

		final Integer value = new Integer(valueToSet);
		Field[] fields = obj.getClass().getDeclaredFields();
		for (int idx = 0; idx < fields.length; idx++) {
			if (Modifier.isPrivate(fields[idx].getModifiers())){

				if (fields[idx].getType() == int.class) {
					 fields[idx].setAccessible(true); 
					fields[idx].set(obj, value);
				}
			}
		}

	}

	/**
	 * Demo Method.
	 * 
	 * @param args
	 *            Command line arguments.
	 * @throws IllegalAccessException
	 * @throws IllegalArgumentException
	 */
	public static final void main(final String[] args)
			throws IllegalArgumentException, IllegalAccessException {
		SomeNumbers values = new SomeNumbers(21.25d, 5665, 1019);
		System.out.println("Before: " + values);
		modifyPublicIntFields(values, 3);
		System.out.println("After public modification: " + values);
		modifyPrivateIntFields(values, 11);
		System.out.println("After private modification: " + values);
	}
}

class SomeNumbers {
	/** A demo double. */
	public double doubleValue;;

	/** A Demo int */
	public int publicValue;;

	/** Another demo int. */
	private int privateValue;

	/**
	 * @param doubleValue
	 * @param privateValue
	 * @param publicValue
	 */
	public SomeNumbers(double doubleValue, int privateValue, int publicValue) {
		this.doubleValue = doubleValue;
		this.privateValue = privateValue;
		this.publicValue = publicValue;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return new String("[doubleValue=" + doubleValue + ", privateValue="
				+ privateValue + ", publicValue=" + publicValue + "]");
	}
}