package saw.reflection.newInstance;
import java.awt.Rectangle;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class SampleNewInstanceWithArguments {

  public static void main(String[] args) throws Exception {

    Rectangle rectangle;
    Class rectangleDefinition;
    Class[] intArgsClass = new Class[] { int.class, int.class };
    Integer height = new Integer(12);
    Integer width = new Integer(34);
    Object[] intArgs = new Object[] { height, width };
    Constructor intArgsConstructor;

    
      rectangleDefinition = Class.forName("java.awt.Rectangle");
      intArgsConstructor = rectangleDefinition
          .getConstructor(intArgsClass);
      rectangle = (Rectangle) createObject(intArgsConstructor, intArgs);
    
  }
/**
 * Invoke a given constructor with some values
 * @param constructor
 * @param arguments
 * @return 
 * @throws Exception
 */
  public static Object createObject(Constructor constructor,
      Object[] arguments) throws Exception {

    System.out.println("Constructor: " + constructor.toString());
    Object object = null;

  
      object = constructor.newInstance(arguments);
      System.out.println("Object: " + object.toString());
      return object;
    
  }
}