package saw.reflection.show.method;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

import saw.reflection.show.Secret;

public class SampleShowMethods {

  public static void main(String[] args) {
    List p = new ArrayList();
    showPublicMethods(p);
    showAllMethods(p);
    
//    Secret secret = new Secret();
//    showPublicMethods(secret);
//    showAllMethods(secret);
  }

  static void showPublicMethods(Object o) {
    Class c = o.getClass();
    Method[] theMethods = c.getMethods();
    System.out.println("Accessible methods");
    printMethods(theMethods);
  }
  
  static void showAllMethods(Object o) {
	    Class c = o.getClass();
	    Method[] theMethods = c.getDeclaredMethods();
	    System.out.println("also private methods");
	    printMethods(theMethods);
	  }

/**
 * @param theMethods
 */
private static void printMethods(Method[] theMethods) {
	for (int i = 0; i < theMethods.length; i++) {
      String methodString = theMethods[i].getName();
      System.out.print("Method name: " + methodString);
      System.out.println("    modifier: "+Modifier.toString(theMethods[i].getModifiers()));
      String returnString = theMethods[i].getReturnType().getName();
      System.out.print("   Return Type: " + returnString);
      Class[] parameterTypes = theMethods[i].getParameterTypes();
      System.out.print("   Parameter Types:");
      for (int k = 0; k < parameterTypes.length; k++) {
        String parameterString = parameterTypes[k].getName();
        System.out.print(" " + parameterString);
      }
      System.out.println();
    }
}




}