import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

import javax.swing.JOptionPane;


public class Principale {

	public static void main(String[] args) {
		/* leggere el pietanze 
		 * dal file pietanze-originai.txt
		 * e cotruire un elenco di pietanze
		 */ 

		try {
			ArrayList<Pietanza> lista = leggiPietanzeDaFile("pietanze-originali.txt");
		
		// chiedere il prezzo massimo
		 
			int prezzoMassimo = chiediPrezzoMassimo();
			
			
		/* selezionare in un nuovo elenco
		 * tutte le pietanze che costano meno
		 * del prezzo massimo*/
			
			ArrayList<Pietanza> listaDeiSelezionati = selezionaPietanze(lista,prezzoMassimo);
		 
		 /* salvare su un file pietanze-selezionate.txt
		 * l'elenco costruito
		 */
			
			salvaPietanzeSelezionate(listaDeiSelezionati,"pietanze-selezionate.txt");
			
		} catch (FileNotFoundException e) {
			JOptionPane.showMessageDialog(null, "File non trovato");
		} catch (IOException e) {
			JOptionPane.showMessageDialog(null, "Errore nella letura del file:"+e.getMessage());
		}
		  catch(NumberFormatException e)
		  {
			  JOptionPane.showMessageDialog(null, "Errore nella conversione stringa intero");
		  }
	}

	private static void salvaPietanzeSelezionate(
			ArrayList<Pietanza> listaDeiSelezionati, String nomeFile) 
		throws IOException {
		
		FileWriter fr = new FileWriter(nomeFile);
		PrintWriter pr = new PrintWriter(fr);
		
		for(Pietanza p : listaDeiSelezionati)
		{
			pr.println(p.getNome());
			pr.println(p.getPrezzo());
		}
		pr.close();
		
	}

	private static ArrayList<Pietanza> selezionaPietanze(
			ArrayList<Pietanza> lista, int prezzoMassimo) {
		
		ArrayList<Pietanza> ris = new ArrayList<Pietanza>();
		
		for(Pietanza p: lista)
		{
			if( p.getPrezzo() <= prezzoMassimo)
			{
				ris.add(p);
			}
		}
		
		return ris;
	}

	private static int chiediPrezzoMassimo() {
		String prezzoMassimo = JOptionPane.showInputDialog("Dammi il prezzo massimo");
		
		return Integer.parseInt(prezzoMassimo);
	}

	private static ArrayList<Pietanza> leggiPietanzeDaFile(String nomeFile) 
	throws IOException, FileNotFoundException{
		/* leggere el pietanze 
		 * dal file pietanze-originai.txt
		 * e cotruire un elenco di pietanze
		 */ 

		FileReader fr = new FileReader(nomeFile);
		BufferedReader br = new BufferedReader(fr);

		ArrayList<Pietanza> ris = new ArrayList<Pietanza>();

		String nome = null;
		String prezzo = null;

		nome = br.readLine();

		try
		{
			while( nome != null )
			{
				prezzo = br.readLine();
				int prezzoIntero = Integer.parseInt(prezzo);
				Pietanza p = new Pietanza(nome,prezzoIntero);
				ris.add(p);
				nome = br.readLine();
			}
		}
		catch (NumberFormatException e) {
			throw new IOException("Errore nel file c'era un prezzo errato");
		}
		
		br.close();
		return ris;
	}

}
